import os
import json
import sys
import argparse
import numpy as np
import cv2
import math
from point import *
from strokes import *
from connect import *
from corner import *

def main():
    parser = argparse.ArgumentParser()

    parser.add_argument('--img_path', type=str, required=True)

    parser.add_argument('--alpha', type=float, required=True)
    parser.add_argument('--beta', type=float, required=True)
    parser.add_argument('--gamma', type=float, required=True)
    parser.add_argument('--lambda_', type=float, required=True)
    parser.add_argument('--mu', type=float, required=True)

    parser.add_argument('--W', type=int, required=True)
    parser.add_argument('--theta0', type=float, required=True)
    parser.add_argument('--rho', type=float, required=True)
    parser.add_argument('--l0', type=float, required=True)
    parser.add_argument('--b', type=float, required=True)
    parser.add_argument('--r', type=float, required=True)
    parser.add_argument('--sigma', type=float, required=True)

    args = parser.parse_args()

    theta0 = math.radians(args.theta0)
    rho = math.radians(args.rho)

    img = cv2.imread(args.img_path, cv2.IMREAD_UNCHANGED)
    img = cv2.copyMakeBorder(img, 1, 1, 1, 1, cv2.BORDER_CONSTANT, value=0)

    R = np.random.rand(img.shape[0], img.shape[1])

    out_img, joints, complexes = classify_segments(img, R, eta=0.7, tau_j=0.9)

    routes, meeti, sim_strokes = get_strokes(out_img, complexes)

    meet_strokes, met_strokes, strokes_new, strokes_cvt, meet_cnt = stroke_match(
        routes, meeti, args.alpha, args.beta, args.gamma, args.lambda_, args.mu)
    strokes = stroke_connect(
        meet_strokes, met_strokes, strokes_new, strokes_cvt, meet_cnt, sim_strokes)

    for i in range(len(strokes)):
        strokes[i] = np.array(strokes[i])

    splitted = split_strokes(
        strokes, args.W, theta0, rho, args.l0, args.b, args.r, args.sigma)

    return splitted

if __name__ == "__main__":
    main()